<?php

class Home {

    const DIR = Bank::HOME_DIR;
    const VIEW_DIR = Bank::HOME_DIR . "/view";
    const RES_DIR = Bank::HOME_DIR . "/resource";
    const ASSETS_DIR = Bank::HOME_DIR . "/assets";
    
    public static $title;
    public static $menu;
    public static $footerMenu;

    public static function init() {

        Bank::resetOptionTags();

        # Short Cut to Assets Directory
        Uss::tag(":assets-dir", Core::url( self::ASSETS_DIR ));

        # Build Main Menu  
        require_once self::RES_DIR . "/menu.php";
        require_once self::RES_DIR . "/menu.footer.php";

    }

    public static function buildPages(array $routers)
{
    foreach ($routers as $route => $data) {

        // data format:
        // [ title, file, withLayout (optional) ]

        $withLayout = $data[2] ?? true;

        Uss::route($route, function () use ($data, $withLayout) {
            self::view($data[0], function () use ($data) {
                require_once self::DIR . "/pages/{$data[1]}";
            }, $withLayout);
        });
    }
}


    public static function view(?string $title, callable $func, bool $withLayout = true)
{
    self::$title = $title;

    // Let Uss decide whether to load header/footer
    Uss::view($func, $withLayout);
}


    public static function buildMenu( Menufy $menu ) {

        $href = $menu->getAttr('href');
        if( $href ) {
            $href = implode("/", array_filter(explode("/", $href)));
            $href = Core::url( ROOT_DIR . "/{$href}" );
        } else $href = 'javascript:void(0)';

        $dropper = empty($menu->child) ? null : 'has-dropdown';

        $html = "<li class='{$dropper}'>";
        $html .= "<a href='{$href}'>{$menu->getAttr('label')}</a>";

        if (!empty($menu->child)) {
            $html .= "<ul class='submenu'>";
            foreach ($menu->child as $childMenu) {
                $html .= self::buildMenu($childMenu);
            }
            $html .= "</ul>";
        }

        $html .= "</li>";
        return $html;
    
    }

    public static function headerFooter( $pinned = false ) {

        $route = Uss::query(0);
        $path = Uss::query(1);

        if( $route == UDASH_ROUTE ) {
            if( Uss::$global['user'] ) {
                if( !in_array($path, ['signup', 'reset']) ) {
                    if( $pinned ) return;
                };
            };
        } else if( $route == UADMIN_ROUTE ) {
            return;
        };

        require_once Home::VIEW_DIR . "/header.php";
        require_once Home::VIEW_DIR . "/footer.php";
        
    }

}