<div class='container-fluid'>

    <h4 class='mb-3'>Transaction History</h4>

    <?php

        $SQL = "
            SELECT 
                %{prefix}_transfers.*,
                %{prefix}_transfer_meta.tx_type as meta_type,
                %{prefix}_transfer_meta.amount as meta_amount,
                %{prefix}_transfer_meta.status as meta_status
            FROM %{prefix}_transfers
            INNER JOIN
                %{prefix}_transfer_meta
            ON
                %{prefix}_transfers.tx_ref = %{prefix}_transfer_meta.tx_ref
            WHERE
                %{prefix}_transfer_meta.account_number = '{$bankNumber}'
            ORDER BY
                %{prefix}_transfers.id DESC
        ";

        $SQL = Core::replace_var( $SQL, ['prefix' => DB_TABLE_PREFIX] );

        $result = Uss::$global['mysqli']->query( $SQL );

        $tablet = new DOMTablet( 'transfers' );

        $tablet->data( $result );

        $tablet->columns([
            'amount',
            'date',
            'tx_ref' => 'transaction ID',
            'status',
            'receipt'
        ]);

        $tablet->wrap();

        $tablet->chunk(25);

        $tablet->prepare(function($data) {

            $currency = Bank::getCurrencies( $data['currency'] );

            if($data['meta_type'] == 'credit') {
                $sign = '';
                $color = 'success';
            } else {
                $sign = '-';
                $color = 'danger';
            };

            $data['amount'] = $sign . $currency['symbol'] . "<span class='text-{$color}'>" . number_format( $data['amount'], 2 ) . "</span>";

            if( $data['meta_status'] ) {
                $data['status'] = "<i class='bi bi-check-circle text-success'></i>";
            } else {
                $data['status'] = "<i class='bi bi-question-circle text-warning'></i>";
            };

            $data['date'] = "<small>" . (new DateTime($data['tx_date']))->format('dS, M Y [h:i A]') . "</small>";

            $href = Core::url( ROOT_DIR . "/" . UDASH_ROUTE . "/receipt/{$data['tx_ref']}" );

            $data['receipt'] = "
                <a href='{$href}' target='blank' class='btn btn-sm btn-outline-primary'>
                    Receipt
                </a>
            ";

            return $data;

        }, true);

    ?>

</div>