<?php

$cardRoute = $moniRoute . "/card";

$cardMenu = $moniMenu->add("card", [
    "label" => "card",
    "href" => Core::url( ROOT_DIR . "/{$cardRoute}" )
]);

# Route Page;

Uss::route( $cardRoute, function() use($cardMenu) {

    $cardMenu->setAttr('active', true);
    $cardMenu->parentMenu->setAttr('active', true);

    Events::addListener('@body:after', function() {
        $file = Core::url( MONETARY_DIR . "/script.js" );
        echo "\t<script src='{$file}'></script>\n";
    });

    ## Post Request

    Monetary::cardApply();

    ## View;
    
    Udash::view(function() {

        # Get Card UI ( Template )

        $card_interface = require Monetary::TEMP_DIR. "/card.php";

        # Render Card Information 

        $bankinfo = Uss::$global['usermeta']->get('bank:info', Uss::$global['user']['id']);
        
        $cardinfo = Monetary::getActiveCard( Uss::$global['user']['id'] );

        if( empty($cardinfo) || $cardinfo['status'] == 'pending' ) {

            $cardinfo = array(
                "client_name" => ucwords( $bankinfo['bio']['firstname'] . " " . $bankinfo['bio']['lastname'] ),
                "expiry" => "xx/xx",
                "card_number" => "3455 **** **** 3594",
                "cvv" => "xxx",
                "logo" => "mastercard-logo.png",
                "vendor" => "mastercard",
                "class-name" => '',
                'color' => 'danger',
                'status' => null,
                'card_type' => 'debit'
            );

        } else $cardinfo['disabled'] = 'disabled';
        
        # Card Vendors & Type

        $cardVendors = [ 
            "mastercard" => "Master Card", 
            "visacard" => "Visa Card" 
        ];

        $cardTypes = [ 
            "debit" => "Debit", 
            "credit" => "Credit" 
        ];

    ?>
        
        <div class='container-fluid'>
            <div class='row justify-content-between'>

                <div class='col-sm-8 col-md-6 col-lg-5 mb-5'>
                    <?php 

                        # Print Master Card
                        echo Core::replace_var( $card_interface, $cardinfo );
                        
                        if( empty($cardinfo['status']) ) {

                            # visa card info
                            $cardinfo['vendor'] = 'visacard';
                            $cardinfo['logo'] = "visa-logo.png";
                            $cardinfo['color'] = 'success';
                            $cardinfo['class-name'] = 'd-none';

                            # Print Visa Card
                            echo Core::replace_var( $card_interface, $cardinfo );

                        };

                    ?>
                </div>

                <div class='col-sm-12 col-md-6 col-lg-6'>

                    <h3 class='mb-3'>Select Card Type</h3>

                    <form method='POST'>
                        <fieldset <?php echo $cardinfo['disabled'] ?? null; ?>>

                            <div class='mb-3'>
                                <select class='form-select form-select-lg' name='card-vendor'>
                                    <?php Bank::array_to_options( $cardVendors ); ?>
                                </select>
                            </div>

                            <div class='mb-3'>
                                <select class='form-select form-select-lg' name='card-type'>
                                    <?php Bank::array_to_options( $cardTypes ); ?>
                                </select>
                            </div>

                            <button class='btn btn-primary btn-lg w-100'>
                                Apply for card
                            </button>

                        </fieldset>
                    </form>

                </div>

            </div>
        </div>

 <?php });

}, null);
