<?php

$statusRoute = $loanRoute . "/status";

$statusMenu = $loanMenu->add("status", [
    "label" => "status",
    "href" => Core::url( ROOT_DIR . "/{$statusRoute}" )
]);

# Routing

Uss::route( $statusRoute, function() use($statusMenu) {

    $statusMenu->setAttr('active', true);
    $statusMenu->parentMenu->setAttr('active', true);

    Udash::view(function() {

        $SQL = SQuery::select( DB_TABLE_PREFIX . "_loans", "1 ORDER BY id DESC" );

        $result = Uss::$global['mysqli']->query( $SQL );

        if( !$result->num_rows ) {
            return Udash::empty_state("You have not applied for any loan");
        }

        $tablet = new DOMTablet('loan');

        $tablet->data( $result );

        $tablet->columns([
            'amount',
            'date',
            'duration', 
            'loan_type' => 'type',
            'reason',
            'status'
        ]);

        $tablet->wrap('container-fluid');
        
        echo "
            <div class='container-fluid mb-3'>
                <h4>Loan Status</h4>
            </div>
        ";

        $tablet->prepare(function($data) {

            $conversion = (new Converter( Uss::$global['user']['id'], 'to' ))
                ->from( 'USD' )
                ->amount( $data['amount'] )
                ->convert();

            $data['amount'] = $conversion->symbol . number_format( $conversion->amount, 2);

            $color = Udash::get_color( $data['status'] );

            $data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";

            return $data;

        }, true);

    });

});