<?php

new class($user) {

    protected $user;
    protected $userinfo;
    protected $userbio;
    protected $fullname;

    protected $post;

    public function __construct($user) {

        $this->user = $user;

        if( $_SERVER['REQUEST_METHOD'] != 'POST' ) return;
        
        $this->post = array_map('trim', $_POST);

        $this->userinfo = Uss::$global['usermeta']->get('bank:info', $this->user['id']);
        $this->userbio = $this->userinfo ? $this->userinfo['bio'] : [];

        $this->fullname = trim(($this->userbio['firstname'] ?? '') . ' ' . ($this->userbio['lastname'] ?? ''));
        
        if( $this->post['request'] == 'modifier' ) {
            $this->modifier();
        } else {
            $this->updateBalance();
        };

    }

    public function modifier() {

        $account = Uss::$global['usermeta']->get('bank:account', $this->user['id']);
        $account['can-transfer'] = $_POST['activate-transfer'];
        $account['verified'] = $_POST['verify-account'];

        $otp = Uss::$global['usermeta']->get('bank:otp', $this->user['id']);
        $otp['email'] = $_POST['activate-email-otp'];
        $otp['transfer_code'] = $_POST['activate-code-otp'];

        $meta = [
            "bank:account" => $account,
            "bank:otp" => $otp
        ];

        foreach( $meta as $key => $value ) {
            Uss::$global['usermeta']->set($key, $value, $this->user['id']);
        };

        Bank::log( 'success', "The user Info has been modified" );

    }

    public function updateBalance() {

        $transaction = array(
            'default' => [
                'amount' => $this->post['amount'],
                'currency' => $this->post['currency'],
                'tx_reason' => $this->post['description'],
                'bank_name' => Uss::$global['options']->get('site:title') ?? Uss::$global['title'],
                'bank_account' => Uss::$global['usermeta']->get('bank:number', $this->user['id']),
                'bank_holder' => $this->fullname,
                'sender_name' => 'Unverified'
            ]
        );

        $type = $this->post['tx_type'];

        $transaction[ $type ] = [
            'userid' => $this->user['id']
        ];

        $result = Bank::transfer( $transaction );

        if( $result ) {
            $amount = number_format( $this->post['amount'], 2 );
            Bank::log( 'success', "The user has been successfully {$_POST['tx_type']}ed an amount of {$amount} {$this->post['currency']}" );
        } else {
            Bank::log('error', "The transaction was not successful");
        };

    }

};