<?php

$coinObject = new class {

    protected $url;
    protected $currencies;

    protected $post;
    protected $mode;
    protected $id;

    public function __construct() {

        $this->config();

        $this->deleteCurrency();

        if( $_SERVER['REQUEST_METHOD'] == 'POST' ) {

            $this->post = $_POST;

            array_walk($this->post, function(&$value, $key) {
                $value = trim($value);
                $value = Uss::$global['mysqli']->real_escape_string( $value );
                if( $key == 'code' ) $value = strtoupper($value);
            });

            $this->manageCurrency();
        };
        
        if( $this->mode == 'edit' ) $this->setTags();

    }

    public function __get($name) {
        return $this->{$name} ?? null;
    }

    protected function config() {

        $this->url = Core::url( ROOT_DIR . "/" . implode("/", array_slice(Uss::query(), 0, 3)) );

        $this->currencies = Uss::$global['options']->get('bank:currencies');

        $this->mode =  Uss::query(3);

        if( $this->mode == 'edit' ) {
            $this->id = Uss::query(4);
        }

    }

    public function setTags() {

        $currency = $this->currencies[ $this->id ] ?? [];

        foreach( $currency as $key => $value ) {
            Uss::tag( "currency-{$key}", $value );
        };

    }

    protected function manageCurrency() {

        if( $this->post['code'] == 'USD' ) {
            return Bank::log( 'info', "You cannot modify \"USD\" which is the default currency" );
        };
        
        if( $this->mode == 'new' ) {

            $code = $this->post['code'];
            $codeList = array_column($this->currencies, 'code');

            if( in_array($code, $codeList) ) {
                return Bank::log( 'info', "The currency \"$code\" has already been added. <br/> Consider editing it instead" );
            };

        };

        $this->saveCurrency();

    }

    protected function saveCurrency() {

        if( $this->id ) {

            $action = 'updated';
            $this->currencies[ $this->id ] = $this->post;

        } else {

            $action = 'added';
            $this->currencies[] = $this->post;

        };

        $inject = Uss::$global['options']->set('bank:currencies', $this->currencies);
        
        if( $inject ) {
            Bank::log( 'success', "The currency was {$action} successfully" );
        } else {
            Bank::log( 'error', "Error: The currency could not be {$action}" );
        };

    }

    protected function deleteCurrency() {
        
        if( empty(Uss::query(3)) && !empty($_GET['remove']) ) {

            $id = $_GET['remove'];

            if( !empty($this->currencies[$id]) ) {

                $code = $this->currencies[ $id ]['code'];
                
                unset( $this->currencies[ $id ] );

                $updated = Uss::$global['options']->set('bank:currencies', $this->currencies);

                if( $updated ) {
                    Bank::log('info', "The \"{$code}\" currency has been deleted");
                } else {
                    Bank::log( 'error', "Sorry! An error occured <br/> The \"{$code}\" currency was not deleted" );
                }

            }

        };  

    }

};