<?php

$addGatewayMenu = $gatewayMenu->add('add', [
    "label" => "add gateway",
    "href" => Core::url( ROOT_DIR . "/{$gatewayRoute}" )
]);

# Focus;

Uss::route( $gatewayRoute . "(?:/(\d+))?", function($match) use($addGatewayMenu) {

    $addGatewayMenu->setAttr('active', true);
    $addGatewayMenu->parentMenu->setAttr('active', true);

    require_once __DIR__ . "/request/gateway.php";
    
    $id = $match[1] ?? 0;

    $gateway = Udash::fetch_assoc( DB_TABLE_PREFIX . "_payment_methods", $id );

    if( !empty($gateway) ) {
        foreach( $gateway as $key => $value ) {
            if( $key == 'icon' ) {
                $value = Core::url( MOD_DIR . "/{$value}" );
            };
            Uss::tag("gateway-{$key}", $value);
        };
    };

    Events::addListener('@body:after', function() {
        $href = Core::url( __DIR__ . "/assets/gateway.js" );
        echo "\t<script src='{$href}'></script>\n";
    });

    Udash::view(function() {

        require_once __DIR__ . "/templates/gateway-temp.php";

    });

}, null);