<div class='container-fluid'>

    <h4>Cheques</h4><hr/>

    <?php

        $SQL = SQuery::select( DB_TABLE_PREFIX . "_cheques", "1 ORDER BY id DESC" );

        $cheques = Uss::$global['mysqli']->query( $SQL );

        $tablet = new DOMTablet( 'cheques' );

        $tablet->data( $cheques );

        $tablet->columns([
            'user',
            'amount',
            'date',
            'status',
            'action'
        ]);

        $tablet->wrap();

        $tablet->prepare(function($data) {

            $data['image'] = Core::url( MOD_DIR . "/{$data['image']}" );

            $encoding = base64_encode( json_encode($data) );

            $user = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $data['userid'] );

            if( $user ) {
                $href = Bank::userURL( $user['usercode'] );
                $data['user'] = "<a href='{$href}'>{$user['email']}</a>";
            } else {
                $data['user'] = "<span class='bi bi-question-circle'></i>";
            };

            $color = Udash::get_color( $data['status'] );
            $data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";

            $data['amount'] = '$' . number_format( $data['amount'], 2 );

            $data['action'] = "
                <button class='btn btn-outline-primary' data-edit='{$encoding}'>
                    <i class='bi bi-eye'></i>
                </button>
                <a href='?remove={$data['id']}' class='btn btn-danger' data-uss-confirm='The cheque will be deleted. <br/> Want to proceed?'>
                    <i class='bi bi-trash'></i>
                </a>
            ";

            return $data;

        }, true);

    ?>
</div>

<template class=''>
    <form method='POST'>
        <fieldset class='p-3'>

            <figure>
                <img src='{{image}}' class='img-fluid img-thumbnail'>
            </figure>

            <div class='mb-3'>
                <label class='form-label'>Amount</label>
                <div class='input-group'>
                    <span class='input-group-text'>$</span>
                    <input type='number' step='0.01' name='amount' class='form-control' value='{{amount}}'>
                </div>
            </div>

            <div class='mb-3'>
                <label class='form-label'>Status</label>
                <select name='status' class='form-select' value='{{status}}'>
                    <option value='approved'>Approved</option>
                    <option value='pending'>Pending</option>
                    <option value='declined'>Declined</option>
                </select>
            </div>

            <div class='form-check mb-3 user-select-none'>
                <input class='form-check-input' type='checkbox' name='credit' value='1' id='001'>
                <label class='form-check-label' for='001'>Credit User On Approval</label>
            </div>

            <input type='hidden' name='id' value='{{id}}'>
            <input type='hidden' name='userid' value='{{userid}}'>

            <button class='btn btn-success w-100'>
                Update Cheque
            </button>

        </fieldset>
    </form>
</template>