<?php

$depositRoute = $financeRoute . "/deposits";

$depositMenu = $financeMenu->add('deposit', [
    "label" => "deposit",
    "href" => Core::url( ROOT_DIR . "/{$depositRoute}" )
]);

# Focus;

Uss::route( $depositRoute, function() use($depositMenu) {

    $depositMenu->setAttr('active', true);
    $depositMenu->parentMenu->setAttr('active', true);

    Events::addListener('@body:after', function() {
        $href = Core::url( FINANCE_DIR . "/assets/deposit.js" );
        echo "\t<script src='{$href}'></script>";
    });

    require_once FINANCE_DIR . '/request/deposits.php';
    
    Udash::view(function() {

        require_once FINANCE_DIR . "/templates/deposits.php";

    });

}, null);